import React, { useState } from "react";
export default function Login() {
  const [username, setUsername] = useState("");
  const [password, setPassword] = useState("");
  const [err, setErr] = useState("");
  const doLogin = e => {
    e.preventDefault();
    fetch("/backend/login.php", {
      method: "POST",
      headers: {"Content-Type": "application/x-www-form-urlencoded"},
      body: `username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}`
    }).then(res => res.json()).then(data => {
      if(data.ok) window.location.href = "/";
      else setErr(data.err || "Login gagal");
    });
  };
  return (
    <form onSubmit={doLogin} className="max-w-md mx-auto mt-20 p-8 rounded-xl shadow bg-white">
      <h2 className="text-2xl font-bold mb-4 text-center">Login</h2>
      {err && <div className="text-red-600 mb-2">{err}</div>}
      <input className="border p-2 mb-2 w-full" placeholder="Username" value={username} onChange={e=>setUsername(e.target.value)} />
      <input className="border p-2 mb-4 w-full" placeholder="Password" type="password" value={password} onChange={e=>setPassword(e.target.value)} />
      <button className="w-full bg-orange-500 text-white rounded-lg py-2 font-bold">Login</button>
    </form>
}